<?php
$title=($cfg && is_object($cfg) && $cfg->getTitle())
    ? $cfg->getTitle() : 'ACCESSYSTEM® | '.__('Support Ticket System');
$signin_url = ROOT_PATH . "login.php"
    . ($thisclient ? "?e=".urlencode($thisclient->getEmail()) : "");
$signout_url = ROOT_PATH . "logout.php?auth=".$ost->getLinkToken();

header("Content-Type: text/html; charset=UTF-8");
header("Content-Security-Policy: frame-ancestors ".$cfg->getAllowIframes().";");

if (($lang = Internationalization::getCurrentLanguage())) {
    $langs = array_unique(array($lang, $cfg->getPrimaryLanguage()));
    $langs = Internationalization::rfc1766($langs);
    header("Content-Language: ".implode(', ', $langs));
}
?>
<!DOCTYPE html>
<html<?php
if ($lang
        && ($info = Internationalization::getLanguageInfo($lang))
        && (@$info['direction'] == 'rtl'))
    echo ' dir="rtl" class="rtl"';
if ($lang) {
    echo ' lang="' . $lang . '"';
}
?>>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo Format::htmlchars($title); ?></title>

    <!-- Site Meta
    ============================================= -->
    <link rel="shortlink" href="https://support.accessystem.com">
    <link rel="canonical" href="https://support.accessystem.com/login.php">
    <link rel="preferred" href="https://support.accessystem.com">
    <link rel="index" title="ACCESSYSTEM® - IT Solution & Services" href="https://support.accessystem.com">
    <link rel="start" title="ACCESSYSTEM® - IT Solution & Services" href="https://support.accessystem.com">
    <link rel="alternate" title="ACCESSYSTEM® - IT Solution & Services" href="https://support.accessystem.com" hreflang="en-us">
    <!--link rel="prev" title="ACCESSYSTEM® - IT Solution & Services" href="#">
    <link rel="next" title="ACCESSYSTEM® - IT Solution & Services" href="#"-->
    <link rel="search" href="https://www.accessystem.com/search.html" type="text/html" title="Search | ACCESSYSTEM® - IT Solution & Services">
    
    <meta name="classification" content="Information Technology Business, IT Business, IT Solutions & Services, IT 24x7 Support Services">
    <meta name="url" content="https://support.accessystem.com">
    <meta name="identifier-URL" content="https://support.accessystem.com">
    <meta name="robots" content="index,follow">
    <meta name="author" content="ACCESSYSTEM® - IT Solution & Services, info@accessystem.com">
    <meta name="web_author" content="ACCESSYSTEM® - IT Solution & Services, info@accessystem.com">
    <meta name="copyright" content="ACCESSYSTEM® - IT Solution & Services, info@accessystem.com">
    <meta name="trademark" content="ACCESSYSTEM® - IT Solution & Services, info@accessystem.com">
    <meta name="contact" content="info@accessystem.com">
    <meta name="reply-to" content="info@accessystem.com">
    <meta name="subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="keywords" content="IT Consulting Company, Best IT Consulting Services, IT Outsourcing & IT Support Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting, IT 24x7 Support Services">
    <meta name="category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="revised" content="Thursday 7th January 2010, 5:15 pm">
    <meta name="rating" content="General">
    <meta name="distribution" content="global">
    <meta name="coverage" content="Worldwide">
    <meta name="language" content="en-US">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-touch-fullscreen" content="yes">

    <!--Open Graph data -->  
    <meta name="og:title" content="ACCESSYSTEM® - IT Solution & Services">
    <meta name="og:url" content="https://www.accessystem.com">
    <meta name="og:type" content="website">
    <meta name="og:site_name" content="ACCESSYSTEM® - IT Solution & Services">
    <meta name="og:email" content="info@accessystem.com">
    <meta name="og:phone_number" content="+91 7738 758585">
    <meta name="og:fax_number" content="+91 7738 758585">
    <meta name="geo.position" content="latitude; longitude">
    <!--meta name="og:latitude" content="37.416343">
    <meta name="og:longitude" content="-122.153013"-->
    <meta name="og:street-address" content="Vashi, Sector 17">
    <meta name="og:locality" content="Navi Mumbai">
    <meta name="geo.placename" content="Navi Mumbai">
    <meta name="og:region" content="Maharashtra">
    <meta name="og:postal-code" content="400703">
    <meta name="og:country-name" content="India">
    <meta name="og:image" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">
    <meta name="og:image:secure_url" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">
    <meta name="og:image:type" content="image/jpeg">
    <meta name="og:subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="og:description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="og:keywords" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="og:category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="og:topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="og:summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="og:abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">


    <meta property="og:title" content="ACCESSYSTEM® - IT Solution & Services">
    <meta property="og:url" content="https://www.accessystem.com">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="ACCESSYSTEM® - IT Solution & Services">
    <meta property="og:email" content="info@accessystem.com">
    <meta property="og:phone_number" content="+91 7738 758585">
    <meta property="og:fax_number" content="+91 7738 758585">
    <!--meta property="geo.position" content="latitude; longitude"-->
    <!--meta property="og:latitude" content="37.416343">
    <meta property="og:longitude" content="-122.153013"-->
    <meta property="og:street-address" content="Vashi, Sector 17">
    <meta property="og:locality" content="Navi Mumbai">
    <meta property="geo.placename" content="Navi Mumbai">
    <meta property="og:region" content="Maharashtra">
    <meta property="og:postal-code" content="400703">
    <meta property="og:country-name" content="India">
    <meta property="og:image" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">
    <meta property="og:image:secure_url" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">
    <meta property="og:image:type" content="image/jpeg">
    <meta property="og:subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="og:description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="og:keywords" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="og:category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="og:topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="og:summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="og:abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:site" content="@ACCESSYSTEM_IT">
    <meta name="twitter:url" content="http://bit.ly/2NjWIpE">
    <meta name="twitter:title" content="ACCESSYSTEM® - IT Solution & Services">
    <meta name="twitter:subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:keywords" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="twitter:image" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">

    <meta property="twitter:card" content="summary">
    <meta property="twitter:site" content="@ACCESSYSTEM_IT">
    <meta property="twitter:url" content="http://bit.ly/2NjWIpE">
    <meta property="twitter:title" content="ACCESSYSTEM® - IT Solution & Services">
    <meta property="twitter:subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:keywords" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="twitter:image" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">
    
    <!-- Facebook data -->
    <!--meta name="fb:admins" content="#"-->
    <meta name="fb:app_id" content="682231112175142">
    <meta name="fb:card" content="summary">
    <meta name="fb:site" content="@ACCESSYSTEM_IT">
    <meta name="fb:url" content="https://www.facebook.com/Accessystem-398667280900369">
    <meta name="fb:title" content="ACCESSYSTEM® - IT Solution & Services">
    <meta name="fb:subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:keywords" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta name="fb:image" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">

    <!--meta property="fb:admins" content="#"-->
    <meta property="fb:app_id" content="682231112175142">
    <meta property="fb:card" content="summary">
    <meta property="fb:site" content="@ACCESSYSTEM_IT">
    <meta property="fb:url" content="https://www.facebook.com/Accessystem-398667280900369">
    <meta property="fb:title" content="ACCESSYSTEM® - IT Solution & Services">
    <meta property="fb:subject" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:description" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:keywords" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:category" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:topic" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:summary" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:abstract" content="IT Consulting Services, IT Outsourcing Services, Managed IT Services, IT Solution for SME, OAuth, Cloud & Hosting">
    <meta property="fb:image" content="https://www.accessystem.com/images/accessystem_1200x1200.png" title="ACCESSYSTEM® | IT Solution & Services">
    

    <!-- Favicon
    ============================================= -->
    <link rel="shortcut icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/favicon.ico" type="image/x-icon" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="apple-touch-icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_256x256.png" type="image/png" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_16x16.png" type="image/png" sizes="16x16" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_32x32.png" type="image/png" sizes="32x32" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_48x48.png" type="image/png" sizes="48x48" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_57x57.png" type="image/png" sizes="57x57" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_64x64.png" type="image/png" sizes="64x64" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_72x72.png" type="image/png" sizes="72x72" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_96x96.png" type="image/png" sizes="96x96" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_114x114.png" type="image/png" sizes="114x114" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_128x128.png" type="image/png" sizes="128x128" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_144x144.png" type="image/png" sizes="144x144" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_192x192.png" type="image/png" sizes="192x192" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_256x256.png" type="image/png" sizes="256x256" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_320x320.png" type="image/png" sizes="320x320" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_512x512.png" type="image/png" sizes="512x512" title="ACCESSYSTEM® - IT Solution & Services">
    <link rel="icon" href="<?php echo ROOT_PATH ?>scp/images/accessystem-icons/accessystem_icon_640x640.png" type="image/png" sizes="640x640" title="ACCESSYSTEM® - IT Solution & Services">

    <!-- Stylesheets
    ============================================= -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/bootstrap.css" />
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/swiper.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/dark.css" />
    
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/animate.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/magnific-popup.css" />

    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/responsive.css" />

    <!-- Bootstrap Switch CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/components/bs-switches.css" />

    <!-- Web Fonts Stylesheets
    ============================================= -->
    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Lato:300,400,400i,700|Raleway:300,400,500,600,700|Crete+Round:400i" />
    <link rel="stylesheet" type="text/css" href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" />
    <!--link rel="stylesheet" href="https://accessystem.com/css/web-fonts.css" type="text/css" />
    <link rel="stylesheet" href="css/web-fonts.css" type="text/css" /-->
    <link rel="stylesheet" type="text/css" href="css/gotham-fonts/gotham.css">

    <!-- Icons CSS
    ============================================= -->
    <!--link rel="stylesheet" type="text/css" href="https://accessystem.com/css/font-icons.css" />
    <link rel="stylesheet" type="text/css" href="https://accessystem.com/css/font-awesome.css" />
    <link rel="stylesheet" type="text/css" href="https://accessystem.com/css/font-awesome.min.css" /-->

    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/font-icons.css">   
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/fontawesome.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/fontawesome.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/all.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/all.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo ROOT_PATH; ?>css/font-icons.css" />

    <!-- Google-Optimize Scripts - minimizing page flicke
    ===================================================== -->
    <style>
        .async-hide { opacity: 0 !important} 
    </style>
    
    <script>
        (function(a,s,y,n,c,h,i,d,e){s.className+=' '+y;h.start=1*new Date;
        h.end=i=function(){s.className=s.className.replace(RegExp(' ?'+y),'')};
        (a[n]=a[n]||[]).hide=h;setTimeout(function(){i();h.end=null},c);h.timeout=c;
        })(window,document.documentElement,'async-hide','dataLayer',4000,
        {'GTM-TNKTNQH':true});
    </script>

    <!-- Google-Analytics Scripts
    ============================================= -->
    <script>
        (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
        (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
        m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
        })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

        ga('create', 'UA-113098840-1', 'auto');
        ga('require', 'GTM-TNKTNQH');
        ga('send', 'pageview');
    </script>
    
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-113098840-1"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      gtag('config', 'UA-113098840-1', { 'optimize_id': 'GTM-5R2XGMD'});
    </script>


    <!-- Google Tag Manager
    ============================================= -->
    <script>
        (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-W2VCSNB');
    </script>

    <!-- TopBarTime Script
    ============================================= -->
    
    <script type="text/javascript">
        tday=new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
        tmonth=new Array("January","February","March","April","May","June","July","August","September","October","November","December");

        function GetClock(){
        var d=new Date();
        var nday=d.getDay(),nmonth=d.getMonth(),ndate=d.getDate(),nyear=d.getFullYear();
        var nhour=d.getHours(),nmin=d.getMinutes(),nsec=d.getSeconds(),ap;

        if(nhour==0){ap=" AM";nhour=12;}
        else if(nhour<12){ap=" AM";}
        else if(nhour==12){ap=" PM";}
        else if(nhour>12){ap=" PM";nhour-=12;}

        if(nmin<=9) nmin="0"+nmin;
        if(nsec<=9) nsec="0"+nsec;

        document.getElementById('TopBarTime').innerHTML=""+tday[nday]+",  "+tmonth[nmonth]+" "+ndate+"  -  "+nyear+",   "+nhour+":"+nmin+":"+nsec+ap+"";
        }

        window.onload=function(){
        GetClock();
        setInterval(GetClock,1000);
        }
    </script>

    
	
    <link type="text/css" href="<?php echo ROOT_PATH; ?>css/ui-lightness/jquery-ui-1.10.3.custom.min.css?f1e9e88"
        rel="stylesheet" media="screen" />
    <link rel="stylesheet" href="<?php echo ROOT_PATH ?>css/jquery-ui-timepicker-addon.css?f1e9e88" media="all"/>
    <link rel="stylesheet" href="<?php echo ROOT_PATH; ?>css/thread.css?f1e9e88" media="screen"/>
    <link rel="stylesheet" href="<?php echo ROOT_PATH; ?>css/redactor.css?f1e9e88" media="screen"/>
    <link type="text/css" rel="stylesheet" href="<?php echo ROOT_PATH; ?>css/flags.css?f1e9e88"/>
    <link type="text/css" rel="stylesheet" href="<?php echo ROOT_PATH; ?>css/rtl.css?f1e9e88"/>
    <link type="text/css" rel="stylesheet" href="<?php echo ROOT_PATH; ?>css/select2.min.css?f1e9e88"/>
    
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/jquery-3.4.0.min.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/jquery-ui-1.12.1.custom.min.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/jquery-ui-timepicker-addon.js?f1e9e88"></script>
    <script src="<?php echo ROOT_PATH; ?>js/osticket.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/filedrop.field.js?f1e9e88"></script>
    <script src="<?php echo ROOT_PATH; ?>scp/js/bootstrap-typeahead.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/redactor.min.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/redactor-plugins.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/redactor-osticket.js?f1e9e88"></script>
    <script type="text/javascript" src="<?php echo ROOT_PATH; ?>js/select2.min.js?f1e9e88"></script>
    <?php
    if($ost && ($headers=$ost->getExtraHeaders())) {
        echo "\n\t".implode("\n\t", $headers)."\n";
    }

    // Offer alternate links for search engines
    // @see https://support.google.com/webmasters/answer/189077?hl=en
    if (($all_langs = Internationalization::getConfiguredSystemLanguages())
        && (count($all_langs) > 1)
    ) {
        $langs = Internationalization::rfc1766(array_keys($all_langs));
        $qs = array();
        parse_str($_SERVER['QUERY_STRING'], $qs);
        foreach ($langs as $L) {
            $qs['lang'] = $L; ?>
        <link rel="alternate" href="//<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>?<?php
            echo http_build_query($qs); ?>" hreflang="<?php echo $L; ?>" />
<?php
        } ?>
        <link rel="alternate" href="//<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>"
            hreflang="x-default" />
<?php
    }
    ?>
</head>

<body class="stretched">
     <!-- Document Wrapper
    ============================================= -->
    <div id="wrapper" class="clearfix">

        <!-- Top Bar
        ============================================= -->
        <div id="top-bar">

            <div class="container clearfix" style="height: 44px;">

                <div class="col_half nobottommargin" style="height: 44px;">
                    <!-- Date & Time Bar
                    ============================================= -->
                    <div id="top-links">
                        <ul>                                                    
                            <div id="TopBarTime"></div>                            
                        </ul>
                    </div><!-- #top-date & time bar -->
                </div>

                <div class="col_half fright col_last nobottommargin" style="height: 44px;">

                    <!-- Top Login & Profile Links
                    ============================================= -->
                    <div id="top-links">
                        <div class="sf-js-enabled clearfix" style="touch-action: pan-y;">

                            <div>
                         <?php
                            if ($thisclient && is_object($thisclient) && $thisclient->isValid()
                                && !$thisclient->isGuest()) {
                             echo Format::htmlchars($thisclient->getName()).'&nbsp;|';
                             ?>
                            <a href="<?php echo ROOT_PATH; ?>profile.php"><?php echo __('Profile'); ?></a> |
                            <a href="<?php echo ROOT_PATH; ?>tickets.php"><?php echo sprintf(__('Tickets <b>(%d)</b>'), $thisclient->getNumTickets()); ?></a> -
                            <a href="<?php echo $signout_url; ?>"><?php echo __('Sign Out'); ?></a>
                        <?php
                        } elseif($nav) {
                            if ($cfg->getClientRegistrationMode() == 'public') { ?>
                                <?php echo __('Guest User |'); ?> 


                            <?php
                            }
                            
                            if ($thisclient && $thisclient->isValid() && $thisclient->isGuest()) { ?>
                                <a href="<?php echo $signout_url; ?>"><?php echo __('Sign Out'); ?></a><?php
                            }
                            elseif ($cfg->getClientRegistrationMode() != 'disabled') { ?>
                                <a href="<?php echo $signin_url; ?>"><?php echo __('Sign In'); ?></a>
                        <?php
                                        }
                                    } ?>
                            </div>                        
           
                        <?php
                        if (($all_langs = Internationalization::getConfiguredSystemLanguages())
                            && (count($all_langs) > 1)
                        ) {
                            $qs = array();
                            parse_str($_SERVER['QUERY_STRING'], $qs);
                            foreach ($all_langs as $code=>$info) {
                                list($lang, $locale) = explode('_', $code);
                                $qs['lang'] = $code;
                        ?>
                                <a class="flag flag-<?php echo strtolower($locale ?: $info['flag'] ?: $lang); ?>"
                                    href="?<?php echo http_build_query($qs);
                                    ?>" title="<?php echo Internationalization::getLanguageDescription($code); ?>">&nbsp;</a>
                        <?php }
                        } ?>
                                    </p>
                                    </div>
                                   
                                </div>
                                <?php
                                if($nav){ ?>
                        </div>
                    </div><!-- .top-links end -->

                </div>

            </div>

        </div><!-- #top-bar end -->

        <!-- Header
        ============================================= -->
        <header id="header" class="full-header">

            <div id="header-wrap">

                <div class="container clearfix">

                    <div id="primary-menu-trigger"><i class="icon-reorder"></i></div>

                    <!-- Logo
                    ============================================= -->
                    <div id="logo" href="<?php echo ROOT_PATH; ?>index.php">
                        <a href="<?php echo ROOT_PATH; ?>index.php" class="standard-logo" data-dark-logo="images/accessystem-logo-long_white.png"><img src="images/accessystem-logo-long_dark.png" alt="ACCESSYSTEM® - IT Solution & Services Inc | Logo" title="ACCESSYSTEM® - IT Solution & Services Inc | Logo"></a>
                        <a href="<?php echo ROOT_PATH; ?>index.php" class="retina-logo" data-dark-logo="images/accessystem-logo-long_white-2x.png"><img src="images/accessystem-logo-long_dark-2x.png" alt="ACCESSYSTEM® - IT Solution & Services Inc | Logo" title="ACCESSYSTEM® - IT Solution & Services Inc | Logo"></a>
                    </div>

                    <!-- Primary Navigation
                    ============================================= -->

                    <nav id="primary-menu">

                        <ul>
                            <li style="margin:5px 0px -5px 0px"><a href="https://accessystem.com" target="_blank"><i class="fa fa-home"></i></a></li>
                            
                            <li><a href="https://accessystem.com/about-us.html" target="_blank"><div>About Us</div></a></li>
                            
                            <li><a href="https://accessystem.com/services.html" target="_blank"><div>Services</div></a></li>
                                <!--ul>
                                    <li><a href="#"><div>IT CONSULTING SERVICES</div></a>
                                    <li><a href="#"><div>IT OUTSOURCING SERVICES</div></a>
                                    <li><a href="#"><div>MANAGED IT SERVICES</div></a>
                                    <li><a href="#"><div>APPLICATION &amp; WEB-DEVELOPMENT</div></a>
                                </ul>
                            </li-->

                            <li class="mega-menu"><a href="#"><div>Solutions</div></a>
                                <div class="mega-menu-content style-2 clearfix">
                                    <ul class="mega-menu-column col-lg-3">
                                        <li class="mega-menu-title"><a href="https://accessystem.com/cloud-solutions.html" target="_blank"><div><i class="fad fa-cloud"></i>CLoud Solutions</div></a>
                                            <ul>
                                                <li><a href="https://accessystem.com/cloud-microsoft-azure.html" target="_blank"><div><!--i class="fab fa-microsoft"></i-->Microsoft Azure</div></a></li>
                                                <li><a href="https://accessystem.com/cloud-amazone-web-services.html" target="_blank"><div><!--i class="fab fa-aws"></i-->Amazon Web Services</div></a></li>
                                            </ul>
                                        </li>
                                    </ul>
                                    <ul class="mega-menu-column col-lg-3">
                                        <li class="mega-menu-title"><a href="https://accessystem.com/email-solutions.html" target="_blank"><div><i class="fad fa-envelope-open-text"></i>eMail Solutions</div></a>
                                            <ul>
                                                <li><a href="https://accessystem.com/email-solution-o365.html" target="_blank"><div>Microsoft Office 365</div></a></li>
                                                <li><a href="https://accessystem.com/email-services-gsuite.html" target="_blank"><div>Google G-Suite</div></a></li>
                                            </ul>
                                        </li>
                                    </ul>
                                    <ul class="mega-menu-column col-lg-3">
                                        <li class="mega-menu-title"><a href="https://accessystem.com/" target="_blank"><div><i class="fas fa-shield-check"></i>Security Solutions</div></a>
                                            <ul>
                                                <li><a href="https://accessystem.com/full-width.html" target="_blank"><div>Comodo SSL</div></a></li>
                                                <li><a href="https://accessystem.com/full-width-wide.html" target="_blank"><div>SiteLock</div></a></li>
                                                <li><a href="https://accessystem.com/right-sidebar.html" target="_blank"><div>Data Protection</div></a></li>
                                            </ul>
                                        </li>
                                    </ul>
                                    <ul class="mega-menu-column col-lg-3">
                                        <li class="mega-menu-title"><a href="https://accessystem.com/" target="_blank"><div><i class="fad fa-hdd"></i>Backup & Storage</div></a>
                                            <ul>
                                                <li><a href="https://accessystem.com/login-register.html" target="_blank"><div>NetBackup</div></a></li>
                                                <li><a href="https://accessystem.com/login-register-2.html" target="_blank"><div>Veeam Backup</div></a></li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </li>

                            <li style="margin:5px 0px -5px 0px"><a href="https://accessystem.com/contact.html" target="_blank"><i class="fa fa-address-card"></i></a></li>

                        </ul>

                        <!-- Top Search
                        ============================================= -->
                        <div id="top-search">
                            <a href="#" id="top-search-trigger"><i class="icon-search3"></i><i class="icon-line-cross"></i></a>
                            <form action="https://accessystem.com/search.html" target="_blank" method="get">
                                <input type="text" name="q" class="form-control" value="" placeholder="Type &amp; Hit Enter..">
                            </form>
                        </div>
                        <!-- #top-search end -->

                    </nav>
                    <!-- #primary-menu end -->

                </div>

            </div>

        </header><!-- #header end -->
            

        <div id="page-menu">

            <div id="page-menu-wrap">

                <div class="container clearfix">

                    <div class="menu-title">Support <span>Portal</span></div>
                    <nav>
                        <ul>
                        <?php
                        if($nav && ($navs=$nav->getNavLinks()) && is_array($navs)){
                            foreach($navs as $name =>$nav) {
                                echo sprintf('<li><a class="%s %s" href="%s">%s</a></li>%s',$nav['active']?'active':'',$name,(ROOT_PATH.$nav['href']),$nav['desc'],"\n");
                            }
                        } ?>
                    </ul>
                    <?php
                    }else{ ?>
                     <hr>
                    <?php
                    } ?>

                        </ul>
                    </nav>

                    <div id="page-submenu-trigger"><i class="icon-reorder"></i></div>

                </div>

            </div>

        </div><!-- #page-menu end -->

        <!-- Content
        ============================================= -->

            <?php if($errors['err']) { ?>
                <div id="msg_error"><?php echo $errors['err']; ?></div>
            <?php }elseif($msg) { ?>
                <div id="msg_notice"><?php echo $msg; ?></div>
            <?php }elseif($warn) { ?>
                <div id="msg_warning"><?php echo $warn; ?></div>
            <?php } ?>    

    </div>
</div>